import type { Metadata } from "next";
import "./globals.css";

export const metadata: Metadata = {
  title: "beLIVE | Discover Events Worldwide",
  description: "Discover the best events happening around the world. From world-class conferences to spectacular festivals, find events with 1000+ attendees across the globe.",
  keywords: ["events", "live events", "conferences", "festivals", "exhibitions", "networking", "belive"],
  authors: [{ name: "beLIVE" }],
  openGraph: {
    title: "beLIVE | Discover Events Worldwide",
    description: "Find the best live events happening around the world with beLIVE.",
    type: "website",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body className="antialiased">
        {children}
      </body>
    </html>
  );
}
